using System;
using Server;

namespace Server.Items
{
	public class LevelHatOfTheMagi : LevelWizardsHat
	{
		public override int LabelNumber{ get{ return 1061597; } } // Hat of the Magi

		public override int ArtifactRarity{ get{ return 11; } }

		public override int BasePoisonResistance{ get{ return 20; } }
		public override int BaseEnergyResistance{ get{ return 20; } }

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }

		[Constructable]
		public LevelHatOfTheMagi()
		{
			Hue = 0x481;

			Attributes.BonusInt = 20;
			Attributes.RegenMana = 4;
			Attributes.SpellDamage = 50;
			SkillBonuses.SetValues( 0, SkillName.Magery, 20 );
			SkillBonuses.SetValues( 1, SkillName.EvalInt, 20 );
		}
      
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=#9999FF>Spells leech life with mana<basefont color=White>" );
		}

		public LevelHatOfTheMagi( Serial serial ) : base( serial )
		{
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 2 );
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			switch ( version )
			{
				case 1:
				{
					Attributes.BonusInt = 20;
               Attributes.SpellDamage = 50;
					SkillBonuses.SetValues( 0, SkillName.Magery, 25 );
					SkillBonuses.SetValues( 1, SkillName.EvalInt, 25 );
					break;
				}
			}
		}
	}
}